unit frmSample;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls,PrinterLib, Vcl.ComCtrls,
  Vcl.ExtDlgs;

type
  Tfrm_Sample = class(TForm)
    grpConfig: TGroupBox;
    cbbModel: TComboBox;
    lblModel: TLabel;
    lblPort: TLabel;
    cbbPortType: TComboBox;
    edtPortSetting: TEdit;
    btnConnect: TButton;
    btnStop: TButton;
    pgcFunction: TPageControl;
    tsReceipt: TTabSheet;
    tsQRCode: TTabSheet;
    lblAlignment: TLabel;
    lblWidth: TLabel;
    lblData: TLabel;
    cbbAlignment: TComboBox;
    cbbWidth: TComboBox;
    edtData: TEdit;
    btnPrint: TButton;
    redtReceipt: TRichEdit;
    btnPrintReceipt: TButton;
    tsImage: TTabSheet;
    grpPrintImage: TGroupBox;
    grpPrintNVImage: TGroupBox;
    btnPrintImage: TButton;
    btnPrintNVImage: TButton;
    btnSelectNVImage: TButton;
    dlgOpenPic1: TOpenPictureDialog;
    tsBarCode: TTabSheet;
    grpCode128: TGroupBox;
    btnCode128Sample: TButton;
    tsSetting: TTabSheet;
    grpSetting: TGroupBox;
    btnTextBold: TButton;
    btnTextFont: TButton;
    procedure btnConnectClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure PrintQRCode();
    procedure btnPrintClick(Sender: TObject);
    procedure edtDataKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cbbPortTypeSelect(Sender: TObject);
    procedure btnPrintReceiptClick(Sender: TObject);
    function SetBtnEnable(Enable:Boolean):Integer;
    procedure btnPrintImageClick(Sender: TObject);
    procedure btnSelectNVImageClick(Sender: TObject);
    procedure btnPrintNVImageClick(Sender: TObject);
    procedure btnCode128SampleClick(Sender: TObject);
    procedure btnTextBoldClick(Sender: TObject);
    procedure btnTextFontClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }

  end;


var
  frm_Sample: Tfrm_Sample;
  bDownloaded:Boolean = False;
  //printer:Pointer;


implementation

{$R *.dfm}
/// Wide String -> Ansi String
function WideStringToAnsiString(const strWide: WideString; CodePage: Word): AnsiString;
var
  Len: integer;
begin
  Result := '';
  if strWide = '' then Exit;

  Len := WideCharToMultiByte(CodePage,
    WC_COMPOSITECHECK or WC_DISCARDNS or WC_SEPCHARS or WC_DEFAULTCHAR,
    @strWide[1], -1, nil, 0, nil, nil);
  SetLength(Result, Len - 1);

  if Len > 1 then
    WideCharToMultiByte(CodePage,
      WC_COMPOSITECHECK or WC_DISCARDNS or WC_SEPCHARS or WC_DEFAULTCHAR,
      @strWide[1], -1, @Result[1], Len - 1, nil, nil);
end;

/// Ansi String -> Wide String
function AnsiStringToWideString(const strAnsi: AnsiString; CodePage: Word): WideString;
var
  Len: integer;
begin
  Result := '';
  if strAnsi = '' then Exit;

  Len := MultiByteToWideChar(CodePage, MB_PRECOMPOSED, PAnsiChar(@strAnsi[1]), -1, nil, 0);
  SetLength(Result, Len - 1);

  if Len > 1 then
    MultiByteToWideChar(CodePage, MB_PRECOMPOSED, PAnsiChar(@strAnsi[1]), -1, PWideChar(@Result[1]), Len - 1);
end;



procedure Tfrm_Sample.btnCode128SampleClick(Sender: TObject);
const
    //set bar code Minimum width : 2
     setCodeWidth: array[0..2] of byte=($1d,$77,$02);
     //display HRI below the bar code
     displayHRI: array[0..2] of Byte = ($1d,$48,$02);
     //print data : code128 B mode + C mode
     printBarCodeData :array[0..20] of Byte = ($1d,$6b,$49,$11,$7b,$42,$4e,$4f,$3a,$7b,$43,12,34,56,78,90,12,34,56,78,90);
var
  readData: array[0..1] of Byte;
begin
     DirectIO(@setCodeWidth,3,@readData,0,NIL);
     DirectIO(@displayHRI,3,@readData,0,NIL);
     DirectIO(@printBarCodeData,21,@readData,0,NIL);

end;

procedure Tfrm_Sample.btnConnectClick(Sender: TObject);
var
  errNo :Integer;
  modelSetting:string;
  portSetting:string;
begin
  errNo := E_SUCCESS;
  modelSetting := cbbModel.Text;
  portSetting :=  edtPortSetting.Text;

  if(PrinterCreator(modelSetting))then
  begin
   if(errNo<>PortOpen(portSetting))then
   begin
      MessageDlg('Port Failed!',mtWarning,[mbOK],0);
   end
   else
   begin
     SetBtnEnable(True);
   end;
  end
  else
  begin
    MessageDlg('Creator Model Failed!',mtWarning,[mbOK],0);
  end;

end;

procedure Tfrm_Sample.btnPrintClick(Sender: TObject);
begin
  PrintQRCode();
end;

procedure Tfrm_Sample.btnPrintImageClick(Sender: TObject);
var
  Image:string;
begin
  if dlgOpenPic1.Execute then
  begin
     Image := dlgOpenPic1.FileName;
     PrintImage(Image,0);
  end;

end;

procedure Tfrm_Sample.btnPrintNVImageClick(Sender: TObject);
begin
  PrintNVImageCompatible(1,PRINT_IMAGE_NORMAL);
end;

procedure Tfrm_Sample.btnPrintReceiptClick(Sender: TObject);
var
  AnsiStr:AnsiString;
begin
  AnsiStr := WideStringToAnsiString(redtReceipt.Text,860);
  PrintText(AnsiStr);
  CutPaper(FULL_CUT,10);
end;

procedure Tfrm_Sample.btnSelectNVImageClick(Sender: TObject);
var
  ImageList:array[0..10] of string;
  errNO:Integer;
begin
  if dlgOpenPic1.Execute then
  begin
     ImageList[0] := dlgOpenPic1.FileName;
     errNO:=DefineNVImageCompatible(ImageList,1);
     if E_SUCCESS = errNO then
     begin
        MessageDlg('Download image succeed!',mtWarning,[mbOK],0);
     end
     else
     begin
        MessageDlg(Format('Download image failed,Error Code:%d!',[errNO]),mtWarning,[mbOK],0);
     end;
  end;
end;

procedure Tfrm_Sample.btnStopClick(Sender: TObject);
begin
   PortClose();
   SetBtnEnable(False);
end;


procedure Tfrm_Sample.btnTextBoldClick(Sender: TObject);
begin
  if POS('OFF',btnTextBold.Caption)>0 then
  begin
    SetTextBold(1);
    btnTextBold.Caption := 'Bold(ON)' ;
  end
  else
  begin
    SetTextBold(0);
    btnTextBold.Caption := 'Bold(OFF)' ;
  end;

end;

procedure Tfrm_Sample.btnTextFontClick(Sender: TObject);
begin
  if Pos('A',btnTextFont.Caption)>0 then
  begin
    SetTextFont(FONT_B);
    btnTextFont.Caption := 'Font B'
  end
  else
  begin
    SetTextFont(FONT_A);
    btnTextFont.Caption := 'Font A';
  end;

end;

procedure Tfrm_Sample.cbbPortTypeSelect(Sender: TObject);
var
  portType:string;
begin
  portType := cbbPortType.Text;
  if('COM'=portType)then
  begin
    edtPortSetting.Text :='COM1,BAUDRATE_115200';
  end
  else if ('NET'=portType) then
  begin
    edtPortSetting.Text :='Net,192.168.1.37';
  end
  else if ('USB'=portType) then
  begin
    edtPortSetting.Text :='USB';
  end
  else if ('LPT'=portType) then
  begin
    edtPortSetting.Text :='LPT1';
  end
  else
  begin
    edtPortSetting.Text :='Invalid';
  end;
end;

procedure Tfrm_Sample.edtDataKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if(key=13)then
  begin
    PrintQRCode();
  end;
end;

procedure Tfrm_Sample.PrintQRCode();
var
  width:Integer;
  alignment:Integer;
begin
  width:= strtoint(cbbWidth.Text);
  alignment:=cbbAlignment.ItemIndex;
  if(Trim(edtData.Text)='') then
  begin
    MessageDlg('QR code data is empty!',mtWarning,[mbOK],0);
    Exit;
  end;
  PrintSymbol(SYMBOL_QRCODE2,width,alignment,edtData.Text);
end;

function Tfrm_Sample.SetBtnEnable(Enable:Boolean):Integer;
begin
  btnPrint.Enabled := Enable;
  btnStop.Enabled := Enable;
  btnPrintReceipt.Enabled := Enable;
  btnPrintImage.Enabled := Enable;
  btnSelectNVImage.Enabled := Enable;
  btnPrintNVImage.Enabled := Enable;
  btnCode128Sample.Enabled := Enable;
  btnTextBold.Enabled := Enable;
  btnTextFont.Enabled := Enable;
  btnConnect.Enabled := not Enable;
end;



//initialization
//begin
  //SetThreadLocale($0416);
//end;
end.
